function test_suite = testAssemble_components %#ok<*STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
p = polysym.empty;
assertTrue(isempty(p.assemble_components))

function testDefault
p = polysym;
assertEqual(p.assemble_components,{p})

function testSingleChar
p = polysym('x');
assertEqual(p.assemble_components,{p})

function testSingleArray
p = polysym('x',[2 3]);
assertEqual(p.assemble_components,{p})

function testIncompleteArray
polysyms('x1_2','x2_3')
p = [x1_2 x2_3];
assertEqual(p.assemble_components,{p(1), p(2)})

function testColumnVector
p = polysym('x',[3 1]);
assertEqual(p.assemble_components,{p})

function testRowVector
p = polysym('x',[1 3]);
assertEqual(p.assemble_components,{p(:)})

function testVectorIncomplete
polysyms('x1','x3')
p = [x1 x3];
assertEqual(p.assemble_components,{p(1),p(2)})

function testMultipleChars
polysyms('x','y')
p = [x y];
assertEqual(p.assemble_components,{x,y})

function testMixed
% If there is more than one array, they are returned as a list of
% components.
polysyms('x')
p = polysym('w',2);
v = [p(:); x];
assertEqual(v.assemble_components,{p(1);p(2);p(3);p(4);x})

function testOverlap
% Repetitions in terms are ignored.
polysyms x1 x2 x3
v = [x1 x2 x2 x3];
assertEqual(v.assemble_components,{[x1; x2; x3]})

function testZeroIndex
polysyms l0 l1
v = [l0 l1];
assertEqual(v.assemble_components,{l0 l1})
